%%
clc;
clear all;
close all;

% Generate a sample waveform with spikes
t = linspace(0, 10*pi, 1000);
x = sin(t) + 0.2*randn(size(t));
x(200:220) = 3;
x(800:820) = -3;



% Detect the spike locations
spike_inds = find(abs(x) > 2);

% Divide the waveform into two phases
phase1_inds = 1:spike_inds(1);
phase2_inds = spike_inds(1)+1:length(x);

% Calculate the average value of each phase
phase1_avg = mean(x(phase1_inds));
phase2_avg = mean(x(phase2_inds));

% Print the results
fprintf('Phase 1 average: %f\n', phase1_avg);
fprintf('Phase 2 average: %f\n', phase2_avg);

figure(1);
plot(t,x);
line(get(gca,'xlim'),[phase1_avg phase1_avg],...
             'Color','r','Linewidth',1.5);
        line(get(gca,'xlim'),[phase2_avg phase2_avg],...
             'Color','k','Linewidth',1.5);